package zio.aws.pricing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAttributeValuesResponse(
    attributeValues: Optional[Iterable[zio.aws.pricing.model.AttributeValue]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse = {
    import GetAttributeValuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse
      .builder()
      .optionallyWith(
        attributeValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeValues)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.GetAttributeValuesResponse.ReadOnly =
    zio.aws.pricing.model.GetAttributeValuesResponse.wrap(buildAwsValue())
}
object GetAttributeValuesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.GetAttributeValuesResponse =
      zio.aws.pricing.model.GetAttributeValuesResponse(
        attributeValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def attributeValues
        : Optional[List[zio.aws.pricing.model.AttributeValue.ReadOnly]]
    def nextToken: Optional[String]
    def getAttributeValues: ZIO[Any, AwsError, List[
      zio.aws.pricing.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("attributeValues", attributeValues)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse
  ) extends zio.aws.pricing.model.GetAttributeValuesResponse.ReadOnly {
    override val attributeValues
        : Optional[List[zio.aws.pricing.model.AttributeValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pricing.model.AttributeValue.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse
  ): zio.aws.pricing.model.GetAttributeValuesResponse.ReadOnly = new Wrapper(
    impl
  )
}
