package zio.aws.pricing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Service(
    serviceCode: String,
    attributeNames: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.pricing.model.Service = {
    import Service.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pricing.model.Service
      .builder()
      .serviceCode(serviceCode: java.lang.String)
      .optionallyWith(
        attributeNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.attributeNames)
      .build()
  }
  def asReadOnly: zio.aws.pricing.model.Service.ReadOnly =
    zio.aws.pricing.model.Service.wrap(buildAwsValue())
}
object Service {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pricing.model.Service] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pricing.model.Service = zio.aws.pricing.model
      .Service(serviceCode, attributeNames.map(value => value))
    def serviceCode: String
    def attributeNames: Optional[List[String]]
    def getServiceCode: ZIO[Any, Nothing, String] = ZIO.succeed(serviceCode)
    def getAttributeNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("attributeNames", attributeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pricing.model.Service
  ) extends zio.aws.pricing.model.Service.ReadOnly {
    override val serviceCode: String = impl.serviceCode(): String
    override val attributeNames: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pricing.model.Service
  ): zio.aws.pricing.model.Service.ReadOnly = new Wrapper(impl)
}
