package zio.aws.proton.model
import zio.aws.proton.model.primitives.PipelineRoleArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AccountSettings(
    pipelineProvisioningRepository: Option[
      zio.aws.proton.model.RepositoryBranch
    ] = None,
    pipelineServiceRoleArn: Option[PipelineRoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.AccountSettings = {
    import AccountSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.AccountSettings
      .builder()
      .optionallyWith(
        pipelineProvisioningRepository.map(value => value.buildAwsValue())
      )(_.pipelineProvisioningRepository)
      .optionallyWith(
        pipelineServiceRoleArn.map(value =>
          PipelineRoleArn.unwrap(value): java.lang.String
        )
      )(_.pipelineServiceRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.AccountSettings.ReadOnly =
    zio.aws.proton.model.AccountSettings.wrap(buildAwsValue())
}
object AccountSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.AccountSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.AccountSettings =
      zio.aws.proton.model.AccountSettings(
        pipelineProvisioningRepository.map(value => value.asEditable),
        pipelineServiceRoleArn.map(value => value)
      )
    def pipelineProvisioningRepository
        : Option[zio.aws.proton.model.RepositoryBranch.ReadOnly]
    def pipelineServiceRoleArn: Option[PipelineRoleArn]
    def getPipelineProvisioningRepository
        : ZIO[Any, AwsError, zio.aws.proton.model.RepositoryBranch.ReadOnly] =
      AwsError.unwrapOptionField(
        "pipelineProvisioningRepository",
        pipelineProvisioningRepository
      )
    def getPipelineServiceRoleArn: ZIO[Any, AwsError, PipelineRoleArn] =
      AwsError.unwrapOptionField(
        "pipelineServiceRoleArn",
        pipelineServiceRoleArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.AccountSettings
  ) extends zio.aws.proton.model.AccountSettings.ReadOnly {
    override val pipelineProvisioningRepository
        : Option[zio.aws.proton.model.RepositoryBranch.ReadOnly] = scala
      .Option(impl.pipelineProvisioningRepository())
      .map(value => zio.aws.proton.model.RepositoryBranch.wrap(value))
    override val pipelineServiceRoleArn: Option[PipelineRoleArn] = scala
      .Option(impl.pipelineServiceRoleArn())
      .map(value => zio.aws.proton.model.primitives.PipelineRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.AccountSettings
  ): zio.aws.proton.model.AccountSettings.ReadOnly = new Wrapper(impl)
}
