package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentTemplateResponse(
    environmentTemplate: zio.aws.proton.model.EnvironmentTemplate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateResponse = {
    import CreateEnvironmentTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateResponse
      .builder()
      .environmentTemplate(environmentTemplate.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CreateEnvironmentTemplateResponse.ReadOnly =
    zio.aws.proton.model.CreateEnvironmentTemplateResponse.wrap(buildAwsValue())
}
object CreateEnvironmentTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateEnvironmentTemplateResponse =
      zio.aws.proton.model
        .CreateEnvironmentTemplateResponse(environmentTemplate.asEditable)
    def environmentTemplate: zio.aws.proton.model.EnvironmentTemplate.ReadOnly
    def getEnvironmentTemplate
        : ZIO[Any, Nothing, zio.aws.proton.model.EnvironmentTemplate.ReadOnly] =
      ZIO.succeed(environmentTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateResponse
  ) extends zio.aws.proton.model.CreateEnvironmentTemplateResponse.ReadOnly {
    override val environmentTemplate
        : zio.aws.proton.model.EnvironmentTemplate.ReadOnly =
      zio.aws.proton.model.EnvironmentTemplate.wrap(impl.environmentTemplate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentTemplateResponse
  ): zio.aws.proton.model.CreateEnvironmentTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
