package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateServiceResponse(service: zio.aws.proton.model.Service) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateServiceResponse = {
    import CreateServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateServiceResponse
      .builder()
      .service(service.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CreateServiceResponse.ReadOnly =
    zio.aws.proton.model.CreateServiceResponse.wrap(buildAwsValue())
}
object CreateServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateServiceResponse =
      zio.aws.proton.model.CreateServiceResponse(service.asEditable)
    def service: zio.aws.proton.model.Service.ReadOnly
    def getService: ZIO[Any, Nothing, zio.aws.proton.model.Service.ReadOnly] =
      ZIO.succeed(service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceResponse
  ) extends zio.aws.proton.model.CreateServiceResponse.ReadOnly {
    override val service: zio.aws.proton.model.Service.ReadOnly =
      zio.aws.proton.model.Service.wrap(impl.service())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceResponse
  ): zio.aws.proton.model.CreateServiceResponse.ReadOnly = new Wrapper(impl)
}
