package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateServiceTemplateResponse(
    serviceTemplate: zio.aws.proton.model.ServiceTemplate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateServiceTemplateResponse = {
    import CreateServiceTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateServiceTemplateResponse
      .builder()
      .serviceTemplate(serviceTemplate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CreateServiceTemplateResponse.ReadOnly =
    zio.aws.proton.model.CreateServiceTemplateResponse.wrap(buildAwsValue())
}
object CreateServiceTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateServiceTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateServiceTemplateResponse =
      zio.aws.proton.model
        .CreateServiceTemplateResponse(serviceTemplate.asEditable)
    def serviceTemplate: zio.aws.proton.model.ServiceTemplate.ReadOnly
    def getServiceTemplate
        : ZIO[Any, Nothing, zio.aws.proton.model.ServiceTemplate.ReadOnly] =
      ZIO.succeed(serviceTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceTemplateResponse
  ) extends zio.aws.proton.model.CreateServiceTemplateResponse.ReadOnly {
    override val serviceTemplate
        : zio.aws.proton.model.ServiceTemplate.ReadOnly =
      zio.aws.proton.model.ServiceTemplate.wrap(impl.serviceTemplate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceTemplateResponse
  ): zio.aws.proton.model.CreateServiceTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
