package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteEnvironmentResponse(
    environment: Option[zio.aws.proton.model.Environment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteEnvironmentResponse = {
    import DeleteEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentResponse
      .builder()
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.DeleteEnvironmentResponse.ReadOnly =
    zio.aws.proton.model.DeleteEnvironmentResponse.wrap(buildAwsValue())
}
object DeleteEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteEnvironmentResponse =
      zio.aws.proton.model
        .DeleteEnvironmentResponse(environment.map(value => value.asEditable))
    def environment: Option[zio.aws.proton.model.Environment.ReadOnly]
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.proton.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentResponse
  ) extends zio.aws.proton.model.DeleteEnvironmentResponse.ReadOnly {
    override val environment
        : Option[zio.aws.proton.model.Environment.ReadOnly] = scala
      .Option(impl.environment())
      .map(value => zio.aws.proton.model.Environment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentResponse
  ): zio.aws.proton.model.DeleteEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
