package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteEnvironmentTemplateVersionResponse(
    environmentTemplateVersion: Option[
      zio.aws.proton.model.EnvironmentTemplateVersion
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateVersionResponse = {
    import DeleteEnvironmentTemplateVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateVersionResponse
      .builder()
      .optionallyWith(
        environmentTemplateVersion.map(value => value.buildAwsValue())
      )(_.environmentTemplateVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.DeleteEnvironmentTemplateVersionResponse.ReadOnly =
    zio.aws.proton.model.DeleteEnvironmentTemplateVersionResponse
      .wrap(buildAwsValue())
}
object DeleteEnvironmentTemplateVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.DeleteEnvironmentTemplateVersionResponse =
      zio.aws.proton.model.DeleteEnvironmentTemplateVersionResponse(
        environmentTemplateVersion.map(value => value.asEditable)
      )
    def environmentTemplateVersion
        : Option[zio.aws.proton.model.EnvironmentTemplateVersion.ReadOnly]
    def getEnvironmentTemplateVersion: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.EnvironmentTemplateVersion.ReadOnly
    ] = AwsError.unwrapOptionField(
      "environmentTemplateVersion",
      environmentTemplateVersion
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateVersionResponse
  ) extends zio.aws.proton.model.DeleteEnvironmentTemplateVersionResponse.ReadOnly {
    override val environmentTemplateVersion
        : Option[zio.aws.proton.model.EnvironmentTemplateVersion.ReadOnly] =
      scala
        .Option(impl.environmentTemplateVersion())
        .map(value =>
          zio.aws.proton.model.EnvironmentTemplateVersion.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentTemplateVersionResponse
  ): zio.aws.proton.model.DeleteEnvironmentTemplateVersionResponse.ReadOnly =
    new Wrapper(impl)
}
