package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteServiceTemplateRequest(name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteServiceTemplateRequest = {
    import DeleteServiceTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteServiceTemplateRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.DeleteServiceTemplateRequest.ReadOnly =
    zio.aws.proton.model.DeleteServiceTemplateRequest.wrap(buildAwsValue())
}
object DeleteServiceTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteServiceTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteServiceTemplateRequest =
      zio.aws.proton.model.DeleteServiceTemplateRequest(name)
    def name: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteServiceTemplateRequest
  ) extends zio.aws.proton.model.DeleteServiceTemplateRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteServiceTemplateRequest
  ): zio.aws.proton.model.DeleteServiceTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
