package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteServiceTemplateResponse(
    serviceTemplate: Option[zio.aws.proton.model.ServiceTemplate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteServiceTemplateResponse = {
    import DeleteServiceTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteServiceTemplateResponse
      .builder()
      .optionallyWith(serviceTemplate.map(value => value.buildAwsValue()))(
        _.serviceTemplate
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.DeleteServiceTemplateResponse.ReadOnly =
    zio.aws.proton.model.DeleteServiceTemplateResponse.wrap(buildAwsValue())
}
object DeleteServiceTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteServiceTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteServiceTemplateResponse =
      zio.aws.proton.model.DeleteServiceTemplateResponse(
        serviceTemplate.map(value => value.asEditable)
      )
    def serviceTemplate: Option[zio.aws.proton.model.ServiceTemplate.ReadOnly]
    def getServiceTemplate
        : ZIO[Any, AwsError, zio.aws.proton.model.ServiceTemplate.ReadOnly] =
      AwsError.unwrapOptionField("serviceTemplate", serviceTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteServiceTemplateResponse
  ) extends zio.aws.proton.model.DeleteServiceTemplateResponse.ReadOnly {
    override val serviceTemplate
        : Option[zio.aws.proton.model.ServiceTemplate.ReadOnly] = scala
      .Option(impl.serviceTemplate())
      .map(value => zio.aws.proton.model.ServiceTemplate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteServiceTemplateResponse
  ): zio.aws.proton.model.DeleteServiceTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
