package zio.aws.proton.model
import zio.aws.proton.model.primitives.{ResourceName, TemplateVersionPart}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnvironmentTemplateFilter(
    majorVersion: TemplateVersionPart,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.EnvironmentTemplateFilter = {
    import EnvironmentTemplateFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.EnvironmentTemplateFilter
      .builder()
      .majorVersion(TemplateVersionPart.unwrap(majorVersion): java.lang.String)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.EnvironmentTemplateFilter.ReadOnly =
    zio.aws.proton.model.EnvironmentTemplateFilter.wrap(buildAwsValue())
}
object EnvironmentTemplateFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.EnvironmentTemplateFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.EnvironmentTemplateFilter =
      zio.aws.proton.model.EnvironmentTemplateFilter(majorVersion, templateName)
    def majorVersion: TemplateVersionPart
    def templateName: ResourceName
    def getMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(majorVersion)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.EnvironmentTemplateFilter
  ) extends zio.aws.proton.model.EnvironmentTemplateFilter.ReadOnly {
    override val majorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.majorVersion())
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.EnvironmentTemplateFilter
  ): zio.aws.proton.model.EnvironmentTemplateFilter.ReadOnly = new Wrapper(impl)
}
