package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  DisplayName,
  EnvironmentTemplateArn,
  FullTemplateVersionNumber,
  Timestamp,
  Description,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EnvironmentTemplateSummary(
    arn: EnvironmentTemplateArn,
    createdAt: Timestamp,
    description: Option[Description] = None,
    displayName: Option[DisplayName] = None,
    lastModifiedAt: Timestamp,
    name: ResourceName,
    provisioning: Option[zio.aws.proton.model.Provisioning] = None,
    recommendedVersion: Option[FullTemplateVersionNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.EnvironmentTemplateSummary = {
    import EnvironmentTemplateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.EnvironmentTemplateSummary
      .builder()
      .arn(EnvironmentTemplateArn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .lastModifiedAt(Timestamp.unwrap(lastModifiedAt): Instant)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(provisioning.map(value => value.unwrap))(_.provisioning)
      .optionallyWith(
        recommendedVersion.map(value =>
          FullTemplateVersionNumber.unwrap(value): java.lang.String
        )
      )(_.recommendedVersion)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.EnvironmentTemplateSummary.ReadOnly =
    zio.aws.proton.model.EnvironmentTemplateSummary.wrap(buildAwsValue())
}
object EnvironmentTemplateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.EnvironmentTemplateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.EnvironmentTemplateSummary =
      zio.aws.proton.model.EnvironmentTemplateSummary(
        arn,
        createdAt,
        description.map(value => value),
        displayName.map(value => value),
        lastModifiedAt,
        name,
        provisioning.map(value => value),
        recommendedVersion.map(value => value)
      )
    def arn: EnvironmentTemplateArn
    def createdAt: Timestamp
    def description: Option[Description]
    def displayName: Option[DisplayName]
    def lastModifiedAt: Timestamp
    def name: ResourceName
    def provisioning: Option[zio.aws.proton.model.Provisioning]
    def recommendedVersion: Option[FullTemplateVersionNumber]
    def getArn: ZIO[Any, Nothing, EnvironmentTemplateArn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getLastModifiedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedAt)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getProvisioning: ZIO[Any, AwsError, zio.aws.proton.model.Provisioning] =
      AwsError.unwrapOptionField("provisioning", provisioning)
    def getRecommendedVersion: ZIO[Any, AwsError, FullTemplateVersionNumber] =
      AwsError.unwrapOptionField("recommendedVersion", recommendedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.EnvironmentTemplateSummary
  ) extends zio.aws.proton.model.EnvironmentTemplateSummary.ReadOnly {
    override val arn: EnvironmentTemplateArn =
      zio.aws.proton.model.primitives.EnvironmentTemplateArn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val displayName: Option[DisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.proton.model.primitives.DisplayName(value))
    override val lastModifiedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.lastModifiedAt())
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val provisioning: Option[zio.aws.proton.model.Provisioning] = scala
      .Option(impl.provisioning())
      .map(value => zio.aws.proton.model.Provisioning.wrap(value))
    override val recommendedVersion: Option[FullTemplateVersionNumber] = scala
      .Option(impl.recommendedVersion())
      .map(value =>
        zio.aws.proton.model.primitives.FullTemplateVersionNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.EnvironmentTemplateSummary
  ): zio.aws.proton.model.EnvironmentTemplateSummary.ReadOnly = new Wrapper(
    impl
  )
}
