package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetServiceInstanceRequest(
    name: ResourceName,
    serviceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetServiceInstanceRequest = {
    import GetServiceInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetServiceInstanceRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetServiceInstanceRequest.ReadOnly =
    zio.aws.proton.model.GetServiceInstanceRequest.wrap(buildAwsValue())
}
object GetServiceInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetServiceInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetServiceInstanceRequest =
      zio.aws.proton.model.GetServiceInstanceRequest(name, serviceName)
    def name: ResourceName
    def serviceName: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetServiceInstanceRequest
  ) extends zio.aws.proton.model.GetServiceInstanceRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetServiceInstanceRequest
  ): zio.aws.proton.model.GetServiceInstanceRequest.ReadOnly = new Wrapper(impl)
}
