package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetServiceInstanceResponse(
    serviceInstance: zio.aws.proton.model.ServiceInstance
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetServiceInstanceResponse = {
    import GetServiceInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetServiceInstanceResponse
      .builder()
      .serviceInstance(serviceInstance.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetServiceInstanceResponse.ReadOnly =
    zio.aws.proton.model.GetServiceInstanceResponse.wrap(buildAwsValue())
}
object GetServiceInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetServiceInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetServiceInstanceResponse =
      zio.aws.proton.model
        .GetServiceInstanceResponse(serviceInstance.asEditable)
    def serviceInstance: zio.aws.proton.model.ServiceInstance.ReadOnly
    def getServiceInstance
        : ZIO[Any, Nothing, zio.aws.proton.model.ServiceInstance.ReadOnly] =
      ZIO.succeed(serviceInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetServiceInstanceResponse
  ) extends zio.aws.proton.model.GetServiceInstanceResponse.ReadOnly {
    override val serviceInstance
        : zio.aws.proton.model.ServiceInstance.ReadOnly =
      zio.aws.proton.model.ServiceInstance.wrap(impl.serviceInstance())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetServiceInstanceResponse
  ): zio.aws.proton.model.GetServiceInstanceResponse.ReadOnly = new Wrapper(
    impl
  )
}
