package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetServiceTemplateVersionResponse(
    serviceTemplateVersion: zio.aws.proton.model.ServiceTemplateVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionResponse = {
    import GetServiceTemplateVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionResponse
      .builder()
      .serviceTemplateVersion(serviceTemplateVersion.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.GetServiceTemplateVersionResponse.ReadOnly =
    zio.aws.proton.model.GetServiceTemplateVersionResponse.wrap(buildAwsValue())
}
object GetServiceTemplateVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetServiceTemplateVersionResponse =
      zio.aws.proton.model
        .GetServiceTemplateVersionResponse(serviceTemplateVersion.asEditable)
    def serviceTemplateVersion
        : zio.aws.proton.model.ServiceTemplateVersion.ReadOnly
    def getServiceTemplateVersion: ZIO[
      Any,
      Nothing,
      zio.aws.proton.model.ServiceTemplateVersion.ReadOnly
    ] = ZIO.succeed(serviceTemplateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionResponse
  ) extends zio.aws.proton.model.GetServiceTemplateVersionResponse.ReadOnly {
    override val serviceTemplateVersion
        : zio.aws.proton.model.ServiceTemplateVersion.ReadOnly =
      zio.aws.proton.model.ServiceTemplateVersion
        .wrap(impl.serviceTemplateVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionResponse
  ): zio.aws.proton.model.GetServiceTemplateVersionResponse.ReadOnly =
    new Wrapper(impl)
}
