package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTemplateSyncConfigResponse(
    templateSyncConfig: Option[zio.aws.proton.model.TemplateSyncConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetTemplateSyncConfigResponse = {
    import GetTemplateSyncConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetTemplateSyncConfigResponse
      .builder()
      .optionallyWith(templateSyncConfig.map(value => value.buildAwsValue()))(
        _.templateSyncConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetTemplateSyncConfigResponse.ReadOnly =
    zio.aws.proton.model.GetTemplateSyncConfigResponse.wrap(buildAwsValue())
}
object GetTemplateSyncConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetTemplateSyncConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetTemplateSyncConfigResponse =
      zio.aws.proton.model.GetTemplateSyncConfigResponse(
        templateSyncConfig.map(value => value.asEditable)
      )
    def templateSyncConfig
        : Option[zio.aws.proton.model.TemplateSyncConfig.ReadOnly]
    def getTemplateSyncConfig
        : ZIO[Any, AwsError, zio.aws.proton.model.TemplateSyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("templateSyncConfig", templateSyncConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetTemplateSyncConfigResponse
  ) extends zio.aws.proton.model.GetTemplateSyncConfigResponse.ReadOnly {
    override val templateSyncConfig
        : Option[zio.aws.proton.model.TemplateSyncConfig.ReadOnly] = scala
      .Option(impl.templateSyncConfig())
      .map(value => zio.aws.proton.model.TemplateSyncConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetTemplateSyncConfigResponse
  ): zio.aws.proton.model.GetTemplateSyncConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
