package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTemplateSyncStatusResponse(
    desiredState: Option[zio.aws.proton.model.Revision] = None,
    latestSuccessfulSync: Option[zio.aws.proton.model.ResourceSyncAttempt] =
      None,
    latestSync: Option[zio.aws.proton.model.ResourceSyncAttempt] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusResponse = {
    import GetTemplateSyncStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusResponse
      .builder()
      .optionallyWith(desiredState.map(value => value.buildAwsValue()))(
        _.desiredState
      )
      .optionallyWith(latestSuccessfulSync.map(value => value.buildAwsValue()))(
        _.latestSuccessfulSync
      )
      .optionallyWith(latestSync.map(value => value.buildAwsValue()))(
        _.latestSync
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetTemplateSyncStatusResponse.ReadOnly =
    zio.aws.proton.model.GetTemplateSyncStatusResponse.wrap(buildAwsValue())
}
object GetTemplateSyncStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetTemplateSyncStatusResponse =
      zio.aws.proton.model.GetTemplateSyncStatusResponse(
        desiredState.map(value => value.asEditable),
        latestSuccessfulSync.map(value => value.asEditable),
        latestSync.map(value => value.asEditable)
      )
    def desiredState: Option[zio.aws.proton.model.Revision.ReadOnly]
    def latestSuccessfulSync
        : Option[zio.aws.proton.model.ResourceSyncAttempt.ReadOnly]
    def latestSync: Option[zio.aws.proton.model.ResourceSyncAttempt.ReadOnly]
    def getDesiredState
        : ZIO[Any, AwsError, zio.aws.proton.model.Revision.ReadOnly] =
      AwsError.unwrapOptionField("desiredState", desiredState)
    def getLatestSuccessfulSync: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ResourceSyncAttempt.ReadOnly
    ] = AwsError.unwrapOptionField("latestSuccessfulSync", latestSuccessfulSync)
    def getLatestSync: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ResourceSyncAttempt.ReadOnly
    ] = AwsError.unwrapOptionField("latestSync", latestSync)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusResponse
  ) extends zio.aws.proton.model.GetTemplateSyncStatusResponse.ReadOnly {
    override val desiredState: Option[zio.aws.proton.model.Revision.ReadOnly] =
      scala
        .Option(impl.desiredState())
        .map(value => zio.aws.proton.model.Revision.wrap(value))
    override val latestSuccessfulSync
        : Option[zio.aws.proton.model.ResourceSyncAttempt.ReadOnly] = scala
      .Option(impl.latestSuccessfulSync())
      .map(value => zio.aws.proton.model.ResourceSyncAttempt.wrap(value))
    override val latestSync
        : Option[zio.aws.proton.model.ResourceSyncAttempt.ReadOnly] = scala
      .Option(impl.latestSync())
      .map(value => zio.aws.proton.model.ResourceSyncAttempt.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetTemplateSyncStatusResponse
  ): zio.aws.proton.model.GetTemplateSyncStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
