package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ResourceName,
  NextToken,
  MaxPageResults,
  TemplateVersionPart
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEnvironmentTemplateVersionsRequest(
    majorVersion: Option[TemplateVersionPart] = None,
    maxResults: Option[MaxPageResults] = None,
    nextToken: Option[NextToken] = None,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest = {
    import ListEnvironmentTemplateVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest
      .builder()
      .optionallyWith(
        majorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.majorVersion)
      .optionallyWith(
        maxResults.map(value => MaxPageResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListEnvironmentTemplateVersionsRequest.ReadOnly =
    zio.aws.proton.model.ListEnvironmentTemplateVersionsRequest
      .wrap(buildAwsValue())
}
object ListEnvironmentTemplateVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.ListEnvironmentTemplateVersionsRequest =
      zio.aws.proton.model.ListEnvironmentTemplateVersionsRequest(
        majorVersion.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        templateName
      )
    def majorVersion: Option[TemplateVersionPart]
    def maxResults: Option[MaxPageResults]
    def nextToken: Option[NextToken]
    def templateName: ResourceName
    def getMajorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("majorVersion", majorVersion)
    def getMaxResults: ZIO[Any, AwsError, MaxPageResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest
  ) extends zio.aws.proton.model.ListEnvironmentTemplateVersionsRequest.ReadOnly {
    override val majorVersion: Option[TemplateVersionPart] = scala
      .Option(impl.majorVersion())
      .map(value => zio.aws.proton.model.primitives.TemplateVersionPart(value))
    override val maxResults: Option[MaxPageResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.proton.model.primitives.MaxPageResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest
  ): zio.aws.proton.model.ListEnvironmentTemplateVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
