package zio.aws.proton.model
import zio.aws.proton.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEnvironmentTemplatesResponse(
    nextToken: Option[NextToken] = None,
    templates: Iterable[zio.aws.proton.model.EnvironmentTemplateSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesResponse = {
    import ListEnvironmentTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .templates(templates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListEnvironmentTemplatesResponse.ReadOnly =
    zio.aws.proton.model.ListEnvironmentTemplatesResponse.wrap(buildAwsValue())
}
object ListEnvironmentTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListEnvironmentTemplatesResponse =
      zio.aws.proton.model.ListEnvironmentTemplatesResponse(
        nextToken.map(value => value),
        templates.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[NextToken]
    def templates
        : List[zio.aws.proton.model.EnvironmentTemplateSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTemplates: ZIO[Any, Nothing, List[
      zio.aws.proton.model.EnvironmentTemplateSummary.ReadOnly
    ]] = ZIO.succeed(templates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesResponse
  ) extends zio.aws.proton.model.ListEnvironmentTemplatesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val templates
        : List[zio.aws.proton.model.EnvironmentTemplateSummary.ReadOnly] = impl
      .templates()
      .asScala
      .map { item =>
        zio.aws.proton.model.EnvironmentTemplateSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesResponse
  ): zio.aws.proton.model.ListEnvironmentTemplatesResponse.ReadOnly =
    new Wrapper(impl)
}
