package zio.aws.proton.model
import zio.aws.proton.model.primitives.EmptyNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListServiceInstanceProvisionedResourcesResponse(
    nextToken: Option[EmptyNextToken] = None,
    provisionedResources: Iterable[zio.aws.proton.model.ProvisionedResource]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesResponse = {
    import ListServiceInstanceProvisionedResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .provisionedResources(provisionedResources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListServiceInstanceProvisionedResourcesResponse.ReadOnly =
    zio.aws.proton.model.ListServiceInstanceProvisionedResourcesResponse
      .wrap(buildAwsValue())
}
object ListServiceInstanceProvisionedResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.ListServiceInstanceProvisionedResourcesResponse =
      zio.aws.proton.model.ListServiceInstanceProvisionedResourcesResponse(
        nextToken.map(value => value),
        provisionedResources.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[EmptyNextToken]
    def provisionedResources
        : List[zio.aws.proton.model.ProvisionedResource.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProvisionedResources: ZIO[Any, Nothing, List[
      zio.aws.proton.model.ProvisionedResource.ReadOnly
    ]] = ZIO.succeed(provisionedResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesResponse
  ) extends zio.aws.proton.model.ListServiceInstanceProvisionedResourcesResponse.ReadOnly {
    override val nextToken: Option[EmptyNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
    override val provisionedResources
        : List[zio.aws.proton.model.ProvisionedResource.ReadOnly] = impl
      .provisionedResources()
      .asScala
      .map { item =>
        zio.aws.proton.model.ProvisionedResource.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesResponse
  ): zio.aws.proton.model.ListServiceInstanceProvisionedResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
