package zio.aws.proton.model
import zio.aws.proton.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListServicesResponse(
    nextToken: Option[NextToken] = None,
    services: Iterable[zio.aws.proton.model.ServiceSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServicesResponse = {
    import ListServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServicesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .services(services.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListServicesResponse.ReadOnly =
    zio.aws.proton.model.ListServicesResponse.wrap(buildAwsValue())
}
object ListServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListServicesResponse =
      zio.aws.proton.model.ListServicesResponse(
        nextToken.map(value => value),
        services.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[NextToken]
    def services: List[zio.aws.proton.model.ServiceSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServices: ZIO[Any, Nothing, List[
      zio.aws.proton.model.ServiceSummary.ReadOnly
    ]] = ZIO.succeed(services)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServicesResponse
  ) extends zio.aws.proton.model.ListServicesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val services: List[zio.aws.proton.model.ServiceSummary.ReadOnly] =
      impl
        .services()
        .asScala
        .map { item =>
          zio.aws.proton.model.ServiceSummary.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServicesResponse
  ): zio.aws.proton.model.ListServicesResponse.ReadOnly = new Wrapper(impl)
}
