package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  SyntheticNotifyResourceDeploymentStatusChangeInputString,
  Arn,
  DeploymentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NotifyResourceDeploymentStatusChangeRequest(
    deploymentId: Option[DeploymentId] = None,
    outputs: Option[Iterable[zio.aws.proton.model.Output]] = None,
    resourceArn: Arn,
    status: zio.aws.proton.model.ResourceDeploymentStatus,
    statusMessage: Option[
      SyntheticNotifyResourceDeploymentStatusChangeInputString
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest = {
    import NotifyResourceDeploymentStatusChangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          SyntheticNotifyResourceDeploymentStatusChangeInputString.unwrap(
            value
          ): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.NotifyResourceDeploymentStatusChangeRequest.ReadOnly =
    zio.aws.proton.model.NotifyResourceDeploymentStatusChangeRequest
      .wrap(buildAwsValue())
}
object NotifyResourceDeploymentStatusChangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.NotifyResourceDeploymentStatusChangeRequest =
      zio.aws.proton.model.NotifyResourceDeploymentStatusChangeRequest(
        deploymentId.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceArn,
        status,
        statusMessage.map(value => value)
      )
    def deploymentId: Option[DeploymentId]
    def outputs: Option[List[zio.aws.proton.model.Output.ReadOnly]]
    def resourceArn: Arn
    def status: zio.aws.proton.model.ResourceDeploymentStatus
    def statusMessage
        : Option[SyntheticNotifyResourceDeploymentStatusChangeInputString]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getOutputs
        : ZIO[Any, AwsError, List[zio.aws.proton.model.Output.ReadOnly]] =
      AwsError.unwrapOptionField("outputs", outputs)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.ResourceDeploymentStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[
      Any,
      AwsError,
      SyntheticNotifyResourceDeploymentStatusChangeInputString
    ] = AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest
  ) extends zio.aws.proton.model.NotifyResourceDeploymentStatusChangeRequest.ReadOnly {
    override val deploymentId: Option[DeploymentId] = scala
      .Option(impl.deploymentId())
      .map(value => zio.aws.proton.model.primitives.DeploymentId(value))
    override val outputs: Option[List[zio.aws.proton.model.Output.ReadOnly]] =
      scala
        .Option(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.proton.model.Output.wrap(item)
          }.toList
        )
    override val resourceArn: Arn =
      zio.aws.proton.model.primitives.Arn(impl.resourceArn())
    override val status: zio.aws.proton.model.ResourceDeploymentStatus =
      zio.aws.proton.model.ResourceDeploymentStatus.wrap(impl.status())
    override val statusMessage
        : Option[SyntheticNotifyResourceDeploymentStatusChangeInputString] =
      scala
        .Option(impl.statusMessage())
        .map(value =>
          zio.aws.proton.model.primitives
            .SyntheticNotifyResourceDeploymentStatusChangeInputString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest
  ): zio.aws.proton.model.NotifyResourceDeploymentStatusChangeRequest.ReadOnly =
    new Wrapper(impl)
}
