package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ProvisionedResourceName,
  ProvisionedResourceIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProvisionedResource(
    identifier: Option[ProvisionedResourceIdentifier] = None,
    name: Option[ProvisionedResourceName] = None,
    provisioningEngine: Option[zio.aws.proton.model.ProvisionedResourceEngine] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ProvisionedResource = {
    import ProvisionedResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ProvisionedResource
      .builder()
      .optionallyWith(
        identifier.map(value =>
          ProvisionedResourceIdentifier.unwrap(value): java.lang.String
        )
      )(_.identifier)
      .optionallyWith(
        name.map(value =>
          ProvisionedResourceName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(provisioningEngine.map(value => value.unwrap))(
        _.provisioningEngine
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ProvisionedResource.ReadOnly =
    zio.aws.proton.model.ProvisionedResource.wrap(buildAwsValue())
}
object ProvisionedResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ProvisionedResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ProvisionedResource =
      zio.aws.proton.model.ProvisionedResource(
        identifier.map(value => value),
        name.map(value => value),
        provisioningEngine.map(value => value)
      )
    def identifier: Option[ProvisionedResourceIdentifier]
    def name: Option[ProvisionedResourceName]
    def provisioningEngine
        : Option[zio.aws.proton.model.ProvisionedResourceEngine]
    def getIdentifier: ZIO[Any, AwsError, ProvisionedResourceIdentifier] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getName: ZIO[Any, AwsError, ProvisionedResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getProvisioningEngine
        : ZIO[Any, AwsError, zio.aws.proton.model.ProvisionedResourceEngine] =
      AwsError.unwrapOptionField("provisioningEngine", provisioningEngine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ProvisionedResource
  ) extends zio.aws.proton.model.ProvisionedResource.ReadOnly {
    override val identifier: Option[ProvisionedResourceIdentifier] = scala
      .Option(impl.identifier())
      .map(value =>
        zio.aws.proton.model.primitives.ProvisionedResourceIdentifier(value)
      )
    override val name: Option[ProvisionedResourceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.proton.model.primitives.ProvisionedResourceName(value)
      )
    override val provisioningEngine
        : Option[zio.aws.proton.model.ProvisionedResourceEngine] = scala
      .Option(impl.provisioningEngine())
      .map(value => zio.aws.proton.model.ProvisionedResourceEngine.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ProvisionedResource
  ): zio.aws.proton.model.ProvisionedResource.ReadOnly = new Wrapper(impl)
}
