package zio.aws.proton.model
import zio.aws.proton.model.primitives.{RepositoryName, Arn, RepositoryArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Repository(
    arn: RepositoryArn,
    connectionArn: Arn,
    encryptionKey: Option[Arn] = None,
    name: RepositoryName,
    provider: zio.aws.proton.model.RepositoryProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.Repository = {
    import Repository.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.Repository
      .builder()
      .arn(RepositoryArn.unwrap(arn): java.lang.String)
      .connectionArn(Arn.unwrap(connectionArn): java.lang.String)
      .optionallyWith(
        encryptionKey.map(value => Arn.unwrap(value): java.lang.String)
      )(_.encryptionKey)
      .name(RepositoryName.unwrap(name): java.lang.String)
      .provider(provider.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.Repository.ReadOnly =
    zio.aws.proton.model.Repository.wrap(buildAwsValue())
}
object Repository {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.proton.model.Repository] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.Repository =
      zio.aws.proton.model.Repository(
        arn,
        connectionArn,
        encryptionKey.map(value => value),
        name,
        provider
      )
    def arn: RepositoryArn
    def connectionArn: Arn
    def encryptionKey: Option[Arn]
    def name: RepositoryName
    def provider: zio.aws.proton.model.RepositoryProvider
    def getArn: ZIO[Any, Nothing, RepositoryArn] = ZIO.succeed(arn)
    def getConnectionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(connectionArn)
    def getEncryptionKey: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getName: ZIO[Any, Nothing, RepositoryName] = ZIO.succeed(name)
    def getProvider
        : ZIO[Any, Nothing, zio.aws.proton.model.RepositoryProvider] =
      ZIO.succeed(provider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.Repository
  ) extends zio.aws.proton.model.Repository.ReadOnly {
    override val arn: RepositoryArn =
      zio.aws.proton.model.primitives.RepositoryArn(impl.arn())
    override val connectionArn: Arn =
      zio.aws.proton.model.primitives.Arn(impl.connectionArn())
    override val encryptionKey: Option[Arn] = scala
      .Option(impl.encryptionKey())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val name: RepositoryName =
      zio.aws.proton.model.primitives.RepositoryName(impl.name())
    override val provider: zio.aws.proton.model.RepositoryProvider =
      zio.aws.proton.model.RepositoryProvider.wrap(impl.provider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.Repository
  ): zio.aws.proton.model.Repository.ReadOnly = new Wrapper(impl)
}
