package zio.aws.proton.model
import scala.jdk.CollectionConverters._
sealed trait ResourceDeploymentStatus {
  def unwrap
      : software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus
}
object ResourceDeploymentStatus {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus
  ): zio.aws.proton.model.ResourceDeploymentStatus = value match {
    case software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.proton.model.ResourceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus =
      software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS
      extends zio.aws.proton.model.ResourceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus =
      software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus.IN_PROGRESS
  }
  case object FAILED extends zio.aws.proton.model.ResourceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus =
      software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus.FAILED
  }
  case object SUCCEEDED extends zio.aws.proton.model.ResourceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus =
      software.amazon.awssdk.services.proton.model.ResourceDeploymentStatus.SUCCEEDED
  }
}
