package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ServiceTemplateArn,
  DisplayName,
  FullTemplateVersionNumber,
  Timestamp,
  Arn,
  Description,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ServiceTemplate(
    arn: ServiceTemplateArn,
    createdAt: Timestamp,
    description: Option[Description] = None,
    displayName: Option[DisplayName] = None,
    encryptionKey: Option[Arn] = None,
    lastModifiedAt: Timestamp,
    name: ResourceName,
    pipelineProvisioning: Option[zio.aws.proton.model.Provisioning] = None,
    recommendedVersion: Option[FullTemplateVersionNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ServiceTemplate = {
    import ServiceTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ServiceTemplate
      .builder()
      .arn(ServiceTemplateArn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        encryptionKey.map(value => Arn.unwrap(value): java.lang.String)
      )(_.encryptionKey)
      .lastModifiedAt(Timestamp.unwrap(lastModifiedAt): Instant)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(pipelineProvisioning.map(value => value.unwrap))(
        _.pipelineProvisioning
      )
      .optionallyWith(
        recommendedVersion.map(value =>
          FullTemplateVersionNumber.unwrap(value): java.lang.String
        )
      )(_.recommendedVersion)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ServiceTemplate.ReadOnly =
    zio.aws.proton.model.ServiceTemplate.wrap(buildAwsValue())
}
object ServiceTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ServiceTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ServiceTemplate =
      zio.aws.proton.model.ServiceTemplate(
        arn,
        createdAt,
        description.map(value => value),
        displayName.map(value => value),
        encryptionKey.map(value => value),
        lastModifiedAt,
        name,
        pipelineProvisioning.map(value => value),
        recommendedVersion.map(value => value)
      )
    def arn: ServiceTemplateArn
    def createdAt: Timestamp
    def description: Option[Description]
    def displayName: Option[DisplayName]
    def encryptionKey: Option[Arn]
    def lastModifiedAt: Timestamp
    def name: ResourceName
    def pipelineProvisioning: Option[zio.aws.proton.model.Provisioning]
    def recommendedVersion: Option[FullTemplateVersionNumber]
    def getArn: ZIO[Any, Nothing, ServiceTemplateArn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEncryptionKey: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getLastModifiedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedAt)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getPipelineProvisioning
        : ZIO[Any, AwsError, zio.aws.proton.model.Provisioning] =
      AwsError.unwrapOptionField("pipelineProvisioning", pipelineProvisioning)
    def getRecommendedVersion: ZIO[Any, AwsError, FullTemplateVersionNumber] =
      AwsError.unwrapOptionField("recommendedVersion", recommendedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ServiceTemplate
  ) extends zio.aws.proton.model.ServiceTemplate.ReadOnly {
    override val arn: ServiceTemplateArn =
      zio.aws.proton.model.primitives.ServiceTemplateArn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val displayName: Option[DisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.proton.model.primitives.DisplayName(value))
    override val encryptionKey: Option[Arn] = scala
      .Option(impl.encryptionKey())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val lastModifiedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.lastModifiedAt())
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val pipelineProvisioning
        : Option[zio.aws.proton.model.Provisioning] = scala
      .Option(impl.pipelineProvisioning())
      .map(value => zio.aws.proton.model.Provisioning.wrap(value))
    override val recommendedVersion: Option[FullTemplateVersionNumber] = scala
      .Option(impl.recommendedVersion())
      .map(value =>
        zio.aws.proton.model.primitives.FullTemplateVersionNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ServiceTemplate
  ): zio.aws.proton.model.ServiceTemplate.ReadOnly = new Wrapper(impl)
}
