package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  TemplateVersionPart,
  Timestamp,
  ServiceTemplateVersionArn,
  Description,
  TemplateSchema,
  StatusMessage,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ServiceTemplateVersion(
    arn: ServiceTemplateVersionArn,
    compatibleEnvironmentTemplates: Iterable[
      zio.aws.proton.model.CompatibleEnvironmentTemplate
    ],
    createdAt: Timestamp,
    description: Option[Description] = None,
    lastModifiedAt: Timestamp,
    majorVersion: TemplateVersionPart,
    minorVersion: TemplateVersionPart,
    recommendedMinorVersion: Option[TemplateVersionPart] = None,
    schema: Option[TemplateSchema] = None,
    status: zio.aws.proton.model.TemplateVersionStatus,
    statusMessage: Option[StatusMessage] = None,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ServiceTemplateVersion = {
    import ServiceTemplateVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ServiceTemplateVersion
      .builder()
      .arn(ServiceTemplateVersionArn.unwrap(arn): java.lang.String)
      .compatibleEnvironmentTemplates(compatibleEnvironmentTemplates.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .lastModifiedAt(Timestamp.unwrap(lastModifiedAt): Instant)
      .majorVersion(TemplateVersionPart.unwrap(majorVersion): java.lang.String)
      .minorVersion(TemplateVersionPart.unwrap(minorVersion): java.lang.String)
      .optionallyWith(
        recommendedMinorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.recommendedMinorVersion)
      .optionallyWith(
        schema.map(value => TemplateSchema.unwrap(value): java.lang.String)
      )(_.schema)
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ServiceTemplateVersion.ReadOnly =
    zio.aws.proton.model.ServiceTemplateVersion.wrap(buildAwsValue())
}
object ServiceTemplateVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ServiceTemplateVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ServiceTemplateVersion =
      zio.aws.proton.model.ServiceTemplateVersion(
        arn,
        compatibleEnvironmentTemplates.map { item =>
          item.asEditable
        },
        createdAt,
        description.map(value => value),
        lastModifiedAt,
        majorVersion,
        minorVersion,
        recommendedMinorVersion.map(value => value),
        schema.map(value => value),
        status,
        statusMessage.map(value => value),
        templateName
      )
    def arn: ServiceTemplateVersionArn
    def compatibleEnvironmentTemplates
        : List[zio.aws.proton.model.CompatibleEnvironmentTemplate.ReadOnly]
    def createdAt: Timestamp
    def description: Option[Description]
    def lastModifiedAt: Timestamp
    def majorVersion: TemplateVersionPart
    def minorVersion: TemplateVersionPart
    def recommendedMinorVersion: Option[TemplateVersionPart]
    def schema: Option[TemplateSchema]
    def status: zio.aws.proton.model.TemplateVersionStatus
    def statusMessage: Option[StatusMessage]
    def templateName: ResourceName
    def getArn: ZIO[Any, Nothing, ServiceTemplateVersionArn] = ZIO.succeed(arn)
    def getCompatibleEnvironmentTemplates: ZIO[Any, Nothing, List[
      zio.aws.proton.model.CompatibleEnvironmentTemplate.ReadOnly
    ]] = ZIO.succeed(compatibleEnvironmentTemplates)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLastModifiedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedAt)
    def getMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(majorVersion)
    def getMinorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(minorVersion)
    def getRecommendedMinorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField(
        "recommendedMinorVersion",
        recommendedMinorVersion
      )
    def getSchema: ZIO[Any, AwsError, TemplateSchema] =
      AwsError.unwrapOptionField("schema", schema)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.TemplateVersionStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ServiceTemplateVersion
  ) extends zio.aws.proton.model.ServiceTemplateVersion.ReadOnly {
    override val arn: ServiceTemplateVersionArn =
      zio.aws.proton.model.primitives.ServiceTemplateVersionArn(impl.arn())
    override val compatibleEnvironmentTemplates
        : List[zio.aws.proton.model.CompatibleEnvironmentTemplate.ReadOnly] =
      impl
        .compatibleEnvironmentTemplates()
        .asScala
        .map { item =>
          zio.aws.proton.model.CompatibleEnvironmentTemplate.wrap(item)
        }
        .toList
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val lastModifiedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.lastModifiedAt())
    override val majorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.majorVersion())
    override val minorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.minorVersion())
    override val recommendedMinorVersion: Option[TemplateVersionPart] = scala
      .Option(impl.recommendedMinorVersion())
      .map(value => zio.aws.proton.model.primitives.TemplateVersionPart(value))
    override val schema: Option[TemplateSchema] = scala
      .Option(impl.schema())
      .map(value => zio.aws.proton.model.primitives.TemplateSchema(value))
    override val status: zio.aws.proton.model.TemplateVersionStatus =
      zio.aws.proton.model.TemplateVersionStatus.wrap(impl.status())
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ServiceTemplateVersion
  ): zio.aws.proton.model.ServiceTemplateVersion.ReadOnly = new Wrapper(impl)
}
