package zio.aws.proton.model
import scala.jdk.CollectionConverters._
sealed trait SyncType {
  def unwrap: software.amazon.awssdk.services.proton.model.SyncType
}
object SyncType {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.SyncType
  ): zio.aws.proton.model.SyncType = value match {
    case software.amazon.awssdk.services.proton.model.SyncType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.SyncType.TEMPLATE_SYNC =>
      val r = TEMPLATE_SYNC
      r
  }
  case object unknownToSdkVersion extends zio.aws.proton.model.SyncType {
    override def unwrap: software.amazon.awssdk.services.proton.model.SyncType =
      software.amazon.awssdk.services.proton.model.SyncType.UNKNOWN_TO_SDK_VERSION
  }
  case object TEMPLATE_SYNC extends zio.aws.proton.model.SyncType {
    override def unwrap: software.amazon.awssdk.services.proton.model.SyncType =
      software.amazon.awssdk.services.proton.model.SyncType.TEMPLATE_SYNC
  }
}
