package zio.aws.proton.model
import zio.aws.proton.model.primitives.{SpecContents, ResourceName, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateServiceRequest(
    description: Option[Description] = None,
    name: ResourceName,
    spec: Option[SpecContents] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateServiceRequest = {
    import UpdateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateServiceRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        spec.map(value => SpecContents.unwrap(value): java.lang.String)
      )(_.spec)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateServiceRequest.ReadOnly =
    zio.aws.proton.model.UpdateServiceRequest.wrap(buildAwsValue())
}
object UpdateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateServiceRequest =
      zio.aws.proton.model.UpdateServiceRequest(
        description.map(value => value),
        name,
        spec.map(value => value)
      )
    def description: Option[Description]
    def name: ResourceName
    def spec: Option[SpecContents]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getSpec: ZIO[Any, AwsError, SpecContents] =
      AwsError.unwrapOptionField("spec", spec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceRequest
  ) extends zio.aws.proton.model.UpdateServiceRequest.ReadOnly {
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val spec: Option[SpecContents] = scala
      .Option(impl.spec())
      .map(value => zio.aws.proton.model.primitives.SpecContents(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceRequest
  ): zio.aws.proton.model.UpdateServiceRequest.ReadOnly = new Wrapper(impl)
}
