package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateServiceTemplateVersionResponse(
    serviceTemplateVersion: zio.aws.proton.model.ServiceTemplateVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionResponse = {
    import UpdateServiceTemplateVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionResponse
      .builder()
      .serviceTemplateVersion(serviceTemplateVersion.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.UpdateServiceTemplateVersionResponse.ReadOnly =
    zio.aws.proton.model.UpdateServiceTemplateVersionResponse
      .wrap(buildAwsValue())
}
object UpdateServiceTemplateVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateServiceTemplateVersionResponse =
      zio.aws.proton.model
        .UpdateServiceTemplateVersionResponse(serviceTemplateVersion.asEditable)
    def serviceTemplateVersion
        : zio.aws.proton.model.ServiceTemplateVersion.ReadOnly
    def getServiceTemplateVersion: ZIO[
      Any,
      Nothing,
      zio.aws.proton.model.ServiceTemplateVersion.ReadOnly
    ] = ZIO.succeed(serviceTemplateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionResponse
  ) extends zio.aws.proton.model.UpdateServiceTemplateVersionResponse.ReadOnly {
    override val serviceTemplateVersion
        : zio.aws.proton.model.ServiceTemplateVersion.ReadOnly =
      zio.aws.proton.model.ServiceTemplateVersion
        .wrap(impl.serviceTemplateVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateServiceTemplateVersionResponse
  ): zio.aws.proton.model.UpdateServiceTemplateVersionResponse.ReadOnly =
    new Wrapper(impl)
}
