package zio.aws.proton.model
import zio.aws.proton.model.primitives.EnvironmentAccountConnectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AcceptEnvironmentAccountConnectionRequest(
    id: EnvironmentAccountConnectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.AcceptEnvironmentAccountConnectionRequest = {
    import AcceptEnvironmentAccountConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.AcceptEnvironmentAccountConnectionRequest
      .builder()
      .id(EnvironmentAccountConnectionId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.AcceptEnvironmentAccountConnectionRequest.ReadOnly =
    zio.aws.proton.model.AcceptEnvironmentAccountConnectionRequest
      .wrap(buildAwsValue())
}
object AcceptEnvironmentAccountConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.AcceptEnvironmentAccountConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.AcceptEnvironmentAccountConnectionRequest =
      zio.aws.proton.model.AcceptEnvironmentAccountConnectionRequest(id)
    def id: EnvironmentAccountConnectionId
    def getId: ZIO[Any, Nothing, EnvironmentAccountConnectionId] =
      ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.AcceptEnvironmentAccountConnectionRequest
  ) extends zio.aws.proton.model.AcceptEnvironmentAccountConnectionRequest.ReadOnly {
    override val id: EnvironmentAccountConnectionId =
      zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.AcceptEnvironmentAccountConnectionRequest
  ): zio.aws.proton.model.AcceptEnvironmentAccountConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
