package zio.aws.proton.model
import scala.jdk.CollectionConverters.*
sealed trait BlockerStatus {
  def unwrap: software.amazon.awssdk.services.proton.model.BlockerStatus
}
object BlockerStatus {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.BlockerStatus
  ): zio.aws.proton.model.BlockerStatus = value match {
    case software.amazon.awssdk.services.proton.model.BlockerStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.BlockerStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.proton.model.BlockerStatus.RESOLVED =>
      val r = RESOLVED
      r
  }
  case object unknownToSdkVersion extends zio.aws.proton.model.BlockerStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.BlockerStatus =
      software.amazon.awssdk.services.proton.model.BlockerStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.proton.model.BlockerStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.BlockerStatus =
      software.amazon.awssdk.services.proton.model.BlockerStatus.ACTIVE
  }
  case object RESOLVED extends zio.aws.proton.model.BlockerStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.BlockerStatus =
      software.amazon.awssdk.services.proton.model.BlockerStatus.RESOLVED
  }
}
