package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelComponentDeploymentRequest(componentName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CancelComponentDeploymentRequest = {
    import CancelComponentDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CancelComponentDeploymentRequest
      .builder()
      .componentName(ResourceName.unwrap(componentName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CancelComponentDeploymentRequest.ReadOnly =
    zio.aws.proton.model.CancelComponentDeploymentRequest.wrap(buildAwsValue())
}
object CancelComponentDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CancelComponentDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CancelComponentDeploymentRequest =
      zio.aws.proton.model.CancelComponentDeploymentRequest(componentName)
    def componentName: ResourceName
    def getComponentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(componentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CancelComponentDeploymentRequest
  ) extends zio.aws.proton.model.CancelComponentDeploymentRequest.ReadOnly {
    override val componentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.componentName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CancelComponentDeploymentRequest
  ): zio.aws.proton.model.CancelComponentDeploymentRequest.ReadOnly =
    new Wrapper(impl)
}
