package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelEnvironmentDeploymentRequest(
    environmentName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentRequest = {
    import CancelEnvironmentDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentRequest
      .builder()
      .environmentName(ResourceName.unwrap(environmentName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CancelEnvironmentDeploymentRequest.ReadOnly =
    zio.aws.proton.model.CancelEnvironmentDeploymentRequest
      .wrap(buildAwsValue())
}
object CancelEnvironmentDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CancelEnvironmentDeploymentRequest =
      zio.aws.proton.model.CancelEnvironmentDeploymentRequest(environmentName)
    def environmentName: ResourceName
    def getEnvironmentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentRequest
  ) extends zio.aws.proton.model.CancelEnvironmentDeploymentRequest.ReadOnly {
    override val environmentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.environmentName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentRequest
  ): zio.aws.proton.model.CancelEnvironmentDeploymentRequest.ReadOnly =
    new Wrapper(impl)
}
