package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelEnvironmentDeploymentResponse(
    environment: zio.aws.proton.model.Environment
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentResponse = {
    import CancelEnvironmentDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentResponse
      .builder()
      .environment(environment.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CancelEnvironmentDeploymentResponse.ReadOnly =
    zio.aws.proton.model.CancelEnvironmentDeploymentResponse
      .wrap(buildAwsValue())
}
object CancelEnvironmentDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CancelEnvironmentDeploymentResponse =
      zio.aws.proton.model
        .CancelEnvironmentDeploymentResponse(environment.asEditable)
    def environment: zio.aws.proton.model.Environment.ReadOnly
    def getEnvironment
        : ZIO[Any, Nothing, zio.aws.proton.model.Environment.ReadOnly] =
      ZIO.succeed(environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentResponse
  ) extends zio.aws.proton.model.CancelEnvironmentDeploymentResponse.ReadOnly {
    override val environment: zio.aws.proton.model.Environment.ReadOnly =
      zio.aws.proton.model.Environment.wrap(impl.environment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CancelEnvironmentDeploymentResponse
  ): zio.aws.proton.model.CancelEnvironmentDeploymentResponse.ReadOnly =
    new Wrapper(impl)
}
