package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelServicePipelineDeploymentRequest(
    serviceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CancelServicePipelineDeploymentRequest = {
    import CancelServicePipelineDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CancelServicePipelineDeploymentRequest
      .builder()
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CancelServicePipelineDeploymentRequest.ReadOnly =
    zio.aws.proton.model.CancelServicePipelineDeploymentRequest
      .wrap(buildAwsValue())
}
object CancelServicePipelineDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CancelServicePipelineDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.CancelServicePipelineDeploymentRequest =
      zio.aws.proton.model.CancelServicePipelineDeploymentRequest(serviceName)
    def serviceName: ResourceName
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CancelServicePipelineDeploymentRequest
  ) extends zio.aws.proton.model.CancelServicePipelineDeploymentRequest.ReadOnly {
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CancelServicePipelineDeploymentRequest
  ): zio.aws.proton.model.CancelServicePipelineDeploymentRequest.ReadOnly =
    new Wrapper(impl)
}
