package zio.aws.proton.model
import zio.aws.proton.model.primitives.{ResourceName, TemplateVersionPart}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CompatibleEnvironmentTemplateInput(
    majorVersion: TemplateVersionPart,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CompatibleEnvironmentTemplateInput = {
    import CompatibleEnvironmentTemplateInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CompatibleEnvironmentTemplateInput
      .builder()
      .majorVersion(TemplateVersionPart.unwrap(majorVersion): java.lang.String)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CompatibleEnvironmentTemplateInput.ReadOnly =
    zio.aws.proton.model.CompatibleEnvironmentTemplateInput
      .wrap(buildAwsValue())
}
object CompatibleEnvironmentTemplateInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CompatibleEnvironmentTemplateInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CompatibleEnvironmentTemplateInput =
      zio.aws.proton.model
        .CompatibleEnvironmentTemplateInput(majorVersion, templateName)
    def majorVersion: TemplateVersionPart
    def templateName: ResourceName
    def getMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(majorVersion)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CompatibleEnvironmentTemplateInput
  ) extends zio.aws.proton.model.CompatibleEnvironmentTemplateInput.ReadOnly {
    override val majorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.majorVersion())
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CompatibleEnvironmentTemplateInput
  ): zio.aws.proton.model.CompatibleEnvironmentTemplateInput.ReadOnly =
    new Wrapper(impl)
}
