package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.{
  Timestamp,
  ComponentArn,
  SpecContents,
  Description,
  StatusMessage,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class Component(
    arn: ComponentArn,
    createdAt: Timestamp,
    deploymentStatus: zio.aws.proton.model.DeploymentStatus,
    deploymentStatusMessage: Optional[StatusMessage] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    environmentName: ResourceName,
    lastClientRequestToken: Optional[String] = Optional.Absent,
    lastDeploymentAttemptedAt: Optional[Timestamp] = Optional.Absent,
    lastDeploymentSucceededAt: Optional[Timestamp] = Optional.Absent,
    lastModifiedAt: Timestamp,
    name: ResourceName,
    serviceInstanceName: Optional[ResourceName] = Optional.Absent,
    serviceName: Optional[ResourceName] = Optional.Absent,
    serviceSpec: Optional[SpecContents] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.Component = {
    import Component.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.Component
      .builder()
      .arn(ComponentArn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .deploymentStatus(deploymentStatus.unwrap)
      .optionallyWith(
        deploymentStatusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.deploymentStatusMessage)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .environmentName(ResourceName.unwrap(environmentName): java.lang.String)
      .optionallyWith(
        lastClientRequestToken.map(value => value: java.lang.String)
      )(_.lastClientRequestToken)
      .optionallyWith(
        lastDeploymentAttemptedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastDeploymentAttemptedAt)
      .optionallyWith(
        lastDeploymentSucceededAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastDeploymentSucceededAt)
      .lastModifiedAt(Timestamp.unwrap(lastModifiedAt): Instant)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        serviceInstanceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.serviceInstanceName)
      .optionallyWith(
        serviceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        serviceSpec.map(value => SpecContents.unwrap(value): java.lang.String)
      )(_.serviceSpec)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.Component.ReadOnly =
    zio.aws.proton.model.Component.wrap(buildAwsValue())
}
object Component {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.proton.model.Component] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.Component =
      zio.aws.proton.model.Component(
        arn,
        createdAt,
        deploymentStatus,
        deploymentStatusMessage.map(value => value),
        description.map(value => value),
        environmentName,
        lastClientRequestToken.map(value => value),
        lastDeploymentAttemptedAt.map(value => value),
        lastDeploymentSucceededAt.map(value => value),
        lastModifiedAt,
        name,
        serviceInstanceName.map(value => value),
        serviceName.map(value => value),
        serviceSpec.map(value => value)
      )
    def arn: ComponentArn
    def createdAt: Timestamp
    def deploymentStatus: zio.aws.proton.model.DeploymentStatus
    def deploymentStatusMessage: Optional[StatusMessage]
    def description: Optional[Description]
    def environmentName: ResourceName
    def lastClientRequestToken: Optional[String]
    def lastDeploymentAttemptedAt: Optional[Timestamp]
    def lastDeploymentSucceededAt: Optional[Timestamp]
    def lastModifiedAt: Timestamp
    def name: ResourceName
    def serviceInstanceName: Optional[ResourceName]
    def serviceName: Optional[ResourceName]
    def serviceSpec: Optional[SpecContents]
    def getArn: ZIO[Any, Nothing, ComponentArn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDeploymentStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentStatus] =
      ZIO.succeed(deploymentStatus)
    def getDeploymentStatusMessage: ZIO[Any, AwsError, StatusMessage] = AwsError
      .unwrapOptionField("deploymentStatusMessage", deploymentStatusMessage)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(environmentName)
    def getLastClientRequestToken: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("lastClientRequestToken", lastClientRequestToken)
    def getLastDeploymentAttemptedAt: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastDeploymentAttemptedAt", lastDeploymentAttemptedAt)
    def getLastDeploymentSucceededAt: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastDeploymentSucceededAt", lastDeploymentSucceededAt)
    def getLastModifiedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedAt)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getServiceInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceInstanceName", serviceInstanceName)
    def getServiceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceSpec: ZIO[Any, AwsError, SpecContents] =
      AwsError.unwrapOptionField("serviceSpec", serviceSpec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.Component
  ) extends zio.aws.proton.model.Component.ReadOnly {
    override val arn: ComponentArn =
      zio.aws.proton.model.primitives.ComponentArn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val deploymentStatus: zio.aws.proton.model.DeploymentStatus =
      zio.aws.proton.model.DeploymentStatus.wrap(impl.deploymentStatus())
    override val deploymentStatusMessage: Optional[StatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatusMessage())
        .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val environmentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.environmentName())
    override val lastClientRequestToken: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastClientRequestToken())
        .map(value => value: String)
    override val lastDeploymentAttemptedAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDeploymentAttemptedAt())
        .map(value => zio.aws.proton.model.primitives.Timestamp(value))
    override val lastDeploymentSucceededAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDeploymentSucceededAt())
        .map(value => zio.aws.proton.model.primitives.Timestamp(value))
    override val lastModifiedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.lastModifiedAt())
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val serviceInstanceName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceInstanceName())
        .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val serviceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val serviceSpec: Optional[SpecContents] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceSpec())
      .map(value => zio.aws.proton.model.primitives.SpecContents(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.Component
  ): zio.aws.proton.model.Component.ReadOnly = new Wrapper(impl)
}
