package zio.aws.proton.model
import scala.jdk.CollectionConverters.*
sealed trait ComponentDeploymentUpdateType {
  def unwrap: software.amazon.awssdk.services.proton.model.ComponentDeploymentUpdateType
}
object ComponentDeploymentUpdateType {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.ComponentDeploymentUpdateType
  ): zio.aws.proton.model.ComponentDeploymentUpdateType = value match {
    case software.amazon.awssdk.services.proton.model.ComponentDeploymentUpdateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.ComponentDeploymentUpdateType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.proton.model.ComponentDeploymentUpdateType.CURRENT_VERSION =>
      val r = CURRENT_VERSION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.proton.model.ComponentDeploymentUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ComponentDeploymentUpdateType =
      software.amazon.awssdk.services.proton.model.ComponentDeploymentUpdateType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.proton.model.ComponentDeploymentUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ComponentDeploymentUpdateType =
      software.amazon.awssdk.services.proton.model.ComponentDeploymentUpdateType.NONE
  }
  case object CURRENT_VERSION
      extends zio.aws.proton.model.ComponentDeploymentUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ComponentDeploymentUpdateType =
      software.amazon.awssdk.services.proton.model.ComponentDeploymentUpdateType.CURRENT_VERSION
  }
}
