package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CountsSummary(
    components: Optional[zio.aws.proton.model.ResourceCountsSummary] =
      Optional.Absent,
    environmentTemplates: Optional[zio.aws.proton.model.ResourceCountsSummary] =
      Optional.Absent,
    environments: Optional[zio.aws.proton.model.ResourceCountsSummary] =
      Optional.Absent,
    pipelines: Optional[zio.aws.proton.model.ResourceCountsSummary] =
      Optional.Absent,
    serviceInstances: Optional[zio.aws.proton.model.ResourceCountsSummary] =
      Optional.Absent,
    serviceTemplates: Optional[zio.aws.proton.model.ResourceCountsSummary] =
      Optional.Absent,
    services: Optional[zio.aws.proton.model.ResourceCountsSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CountsSummary = {
    import CountsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CountsSummary
      .builder()
      .optionallyWith(components.map(value => value.buildAwsValue()))(
        _.components
      )
      .optionallyWith(environmentTemplates.map(value => value.buildAwsValue()))(
        _.environmentTemplates
      )
      .optionallyWith(environments.map(value => value.buildAwsValue()))(
        _.environments
      )
      .optionallyWith(pipelines.map(value => value.buildAwsValue()))(
        _.pipelines
      )
      .optionallyWith(serviceInstances.map(value => value.buildAwsValue()))(
        _.serviceInstances
      )
      .optionallyWith(serviceTemplates.map(value => value.buildAwsValue()))(
        _.serviceTemplates
      )
      .optionallyWith(services.map(value => value.buildAwsValue()))(_.services)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CountsSummary.ReadOnly =
    zio.aws.proton.model.CountsSummary.wrap(buildAwsValue())
}
object CountsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CountsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CountsSummary =
      zio.aws.proton.model.CountsSummary(
        components.map(value => value.asEditable),
        environmentTemplates.map(value => value.asEditable),
        environments.map(value => value.asEditable),
        pipelines.map(value => value.asEditable),
        serviceInstances.map(value => value.asEditable),
        serviceTemplates.map(value => value.asEditable),
        services.map(value => value.asEditable)
      )
    def components
        : Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly]
    def environmentTemplates
        : Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly]
    def environments
        : Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly]
    def pipelines: Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly]
    def serviceInstances
        : Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly]
    def serviceTemplates
        : Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly]
    def services: Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly]
    def getComponents: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ResourceCountsSummary.ReadOnly
    ] = AwsError.unwrapOptionField("components", components)
    def getEnvironmentTemplates: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ResourceCountsSummary.ReadOnly
    ] = AwsError.unwrapOptionField("environmentTemplates", environmentTemplates)
    def getEnvironments: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ResourceCountsSummary.ReadOnly
    ] = AwsError.unwrapOptionField("environments", environments)
    def getPipelines: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ResourceCountsSummary.ReadOnly
    ] = AwsError.unwrapOptionField("pipelines", pipelines)
    def getServiceInstances: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ResourceCountsSummary.ReadOnly
    ] = AwsError.unwrapOptionField("serviceInstances", serviceInstances)
    def getServiceTemplates: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ResourceCountsSummary.ReadOnly
    ] = AwsError.unwrapOptionField("serviceTemplates", serviceTemplates)
    def getServices: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ResourceCountsSummary.ReadOnly
    ] = AwsError.unwrapOptionField("services", services)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CountsSummary
  ) extends zio.aws.proton.model.CountsSummary.ReadOnly {
    override val components
        : Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.components())
        .map(value => zio.aws.proton.model.ResourceCountsSummary.wrap(value))
    override val environmentTemplates
        : Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentTemplates())
        .map(value => zio.aws.proton.model.ResourceCountsSummary.wrap(value))
    override val environments
        : Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environments())
        .map(value => zio.aws.proton.model.ResourceCountsSummary.wrap(value))
    override val pipelines
        : Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelines())
        .map(value => zio.aws.proton.model.ResourceCountsSummary.wrap(value))
    override val serviceInstances
        : Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceInstances())
        .map(value => zio.aws.proton.model.ResourceCountsSummary.wrap(value))
    override val serviceTemplates
        : Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceTemplates())
        .map(value => zio.aws.proton.model.ResourceCountsSummary.wrap(value))
    override val services
        : Optional[zio.aws.proton.model.ResourceCountsSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.services())
        .map(value => zio.aws.proton.model.ResourceCountsSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CountsSummary
  ): zio.aws.proton.model.CountsSummary.ReadOnly = new Wrapper(impl)
}
