package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  SpecContents,
  Description,
  TemplateFileContents,
  ClientToken,
  TemplateManifestContents,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateComponentRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    environmentName: Optional[ResourceName] = Optional.Absent,
    manifest: TemplateManifestContents,
    name: ResourceName,
    serviceInstanceName: Optional[ResourceName] = Optional.Absent,
    serviceName: Optional[ResourceName] = Optional.Absent,
    serviceSpec: Optional[SpecContents] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.proton.model.Tag]] = Optional.Absent,
    templateFile: TemplateFileContents
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateComponentRequest = {
    import CreateComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateComponentRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .manifest(TemplateManifestContents.unwrap(manifest): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        serviceInstanceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.serviceInstanceName)
      .optionallyWith(
        serviceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        serviceSpec.map(value => SpecContents.unwrap(value): java.lang.String)
      )(_.serviceSpec)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .templateFile(TemplateFileContents.unwrap(templateFile): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CreateComponentRequest.ReadOnly =
    zio.aws.proton.model.CreateComponentRequest.wrap(buildAwsValue())
}
object CreateComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateComponentRequest =
      zio.aws.proton.model.CreateComponentRequest(
        clientToken.map(value => value),
        description.map(value => value),
        environmentName.map(value => value),
        manifest,
        name,
        serviceInstanceName.map(value => value),
        serviceName.map(value => value),
        serviceSpec.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        templateFile
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[Description]
    def environmentName: Optional[ResourceName]
    def manifest: TemplateManifestContents
    def name: ResourceName
    def serviceInstanceName: Optional[ResourceName]
    def serviceName: Optional[ResourceName]
    def serviceSpec: Optional[SpecContents]
    def tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]]
    def templateFile: TemplateFileContents
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getManifest: ZIO[Any, Nothing, TemplateManifestContents] =
      ZIO.succeed(manifest)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getServiceInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceInstanceName", serviceInstanceName)
    def getServiceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceSpec: ZIO[Any, AwsError, SpecContents] =
      AwsError.unwrapOptionField("serviceSpec", serviceSpec)
    def getTags: ZIO[Any, AwsError, List[zio.aws.proton.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateFile: ZIO[Any, Nothing, TemplateFileContents] =
      ZIO.succeed(templateFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateComponentRequest
  ) extends zio.aws.proton.model.CreateComponentRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.proton.model.primitives.ClientToken(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val environmentName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val manifest: TemplateManifestContents =
      zio.aws.proton.model.primitives.TemplateManifestContents(impl.manifest())
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val serviceInstanceName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceInstanceName())
        .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val serviceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val serviceSpec: Optional[SpecContents] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceSpec())
      .map(value => zio.aws.proton.model.primitives.SpecContents(value))
    override val tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.proton.model.Tag.wrap(item)
          }.toList
        )
    override val templateFile: TemplateFileContents =
      zio.aws.proton.model.primitives.TemplateFileContents(impl.templateFile())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateComponentRequest
  ): zio.aws.proton.model.CreateComponentRequest.ReadOnly = new Wrapper(impl)
}
