package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateComponentResponse(
    component: zio.aws.proton.model.Component
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateComponentResponse = {
    import CreateComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateComponentResponse
      .builder()
      .component(component.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CreateComponentResponse.ReadOnly =
    zio.aws.proton.model.CreateComponentResponse.wrap(buildAwsValue())
}
object CreateComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateComponentResponse =
      zio.aws.proton.model.CreateComponentResponse(component.asEditable)
    def component: zio.aws.proton.model.Component.ReadOnly
    def getComponent
        : ZIO[Any, Nothing, zio.aws.proton.model.Component.ReadOnly] =
      ZIO.succeed(component)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateComponentResponse
  ) extends zio.aws.proton.model.CreateComponentResponse.ReadOnly {
    override val component: zio.aws.proton.model.Component.ReadOnly =
      zio.aws.proton.model.Component.wrap(impl.component())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateComponentResponse
  ): zio.aws.proton.model.CreateComponentResponse.ReadOnly = new Wrapper(impl)
}
