package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  EnvironmentAccountConnectionId,
  RoleArn,
  TemplateVersionPart,
  Arn,
  SpecContents,
  Description,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateEnvironmentRequest(
    codebuildRoleArn: Optional[RoleArn] = Optional.Absent,
    componentRoleArn: Optional[RoleArn] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    environmentAccountConnectionId: Optional[EnvironmentAccountConnectionId] =
      Optional.Absent,
    name: ResourceName,
    protonServiceRoleArn: Optional[Arn] = Optional.Absent,
    provisioningRepository: Optional[
      zio.aws.proton.model.RepositoryBranchInput
    ] = Optional.Absent,
    spec: SpecContents,
    tags: Optional[Iterable[zio.aws.proton.model.Tag]] = Optional.Absent,
    templateMajorVersion: TemplateVersionPart,
    templateMinorVersion: Optional[TemplateVersionPart] = Optional.Absent,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest = {
    import CreateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest
      .builder()
      .optionallyWith(
        codebuildRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.codebuildRoleArn)
      .optionallyWith(
        componentRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.componentRoleArn)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentAccountConnectionId.map(value =>
          EnvironmentAccountConnectionId.unwrap(value): java.lang.String
        )
      )(_.environmentAccountConnectionId)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        protonServiceRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.protonServiceRoleArn)
      .optionallyWith(
        provisioningRepository.map(value => value.buildAwsValue())
      )(_.provisioningRepository)
      .spec(SpecContents.unwrap(spec): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .templateMajorVersion(
        TemplateVersionPart.unwrap(templateMajorVersion): java.lang.String
      )
      .optionallyWith(
        templateMinorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.templateMinorVersion)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CreateEnvironmentRequest.ReadOnly =
    zio.aws.proton.model.CreateEnvironmentRequest.wrap(buildAwsValue())
}
object CreateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateEnvironmentRequest =
      zio.aws.proton.model.CreateEnvironmentRequest(
        codebuildRoleArn.map(value => value),
        componentRoleArn.map(value => value),
        description.map(value => value),
        environmentAccountConnectionId.map(value => value),
        name,
        protonServiceRoleArn.map(value => value),
        provisioningRepository.map(value => value.asEditable),
        spec,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        templateMajorVersion,
        templateMinorVersion.map(value => value),
        templateName
      )
    def codebuildRoleArn: Optional[RoleArn]
    def componentRoleArn: Optional[RoleArn]
    def description: Optional[Description]
    def environmentAccountConnectionId: Optional[EnvironmentAccountConnectionId]
    def name: ResourceName
    def protonServiceRoleArn: Optional[Arn]
    def provisioningRepository
        : Optional[zio.aws.proton.model.RepositoryBranchInput.ReadOnly]
    def spec: SpecContents
    def tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]]
    def templateMajorVersion: TemplateVersionPart
    def templateMinorVersion: Optional[TemplateVersionPart]
    def templateName: ResourceName
    def getCodebuildRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("codebuildRoleArn", codebuildRoleArn)
    def getComponentRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("componentRoleArn", componentRoleArn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentAccountConnectionId
        : ZIO[Any, AwsError, EnvironmentAccountConnectionId] =
      AwsError.unwrapOptionField(
        "environmentAccountConnectionId",
        environmentAccountConnectionId
      )
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getProtonServiceRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("protonServiceRoleArn", protonServiceRoleArn)
    def getProvisioningRepository: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.RepositoryBranchInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisioningRepository",
      provisioningRepository
    )
    def getSpec: ZIO[Any, Nothing, SpecContents] = ZIO.succeed(spec)
    def getTags: ZIO[Any, AwsError, List[zio.aws.proton.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("templateMinorVersion", templateMinorVersion)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest
  ) extends zio.aws.proton.model.CreateEnvironmentRequest.ReadOnly {
    override val codebuildRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.codebuildRoleArn())
      .map(value => zio.aws.proton.model.primitives.RoleArn(value))
    override val componentRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.componentRoleArn())
      .map(value => zio.aws.proton.model.primitives.RoleArn(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val environmentAccountConnectionId
        : Optional[EnvironmentAccountConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentAccountConnectionId())
      .map(value =>
        zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(value)
      )
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val protonServiceRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.protonServiceRoleArn())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val provisioningRepository
        : Optional[zio.aws.proton.model.RepositoryBranchInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningRepository())
        .map(value => zio.aws.proton.model.RepositoryBranchInput.wrap(value))
    override val spec: SpecContents =
      zio.aws.proton.model.primitives.SpecContents(impl.spec())
    override val tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.proton.model.Tag.wrap(item)
          }.toList
        )
    override val templateMajorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMajorVersion())
    override val templateMinorVersion: Optional[TemplateVersionPart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateMinorVersion())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateVersionPart(value)
        )
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentRequest
  ): zio.aws.proton.model.CreateEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
