package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateEnvironmentResponse(
    environment: zio.aws.proton.model.Environment
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateEnvironmentResponse = {
    import CreateEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateEnvironmentResponse
      .builder()
      .environment(environment.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CreateEnvironmentResponse.ReadOnly =
    zio.aws.proton.model.CreateEnvironmentResponse.wrap(buildAwsValue())
}
object CreateEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateEnvironmentResponse =
      zio.aws.proton.model.CreateEnvironmentResponse(environment.asEditable)
    def environment: zio.aws.proton.model.Environment.ReadOnly
    def getEnvironment
        : ZIO[Any, Nothing, zio.aws.proton.model.Environment.ReadOnly] =
      ZIO.succeed(environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentResponse
  ) extends zio.aws.proton.model.CreateEnvironmentResponse.ReadOnly {
    override val environment: zio.aws.proton.model.Environment.ReadOnly =
      zio.aws.proton.model.Environment.wrap(impl.environment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateEnvironmentResponse
  ): zio.aws.proton.model.CreateEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
