package zio.aws.proton.model
import zio.aws.proton.model.primitives.{RepositoryName, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateRepositoryRequest(
    connectionArn: Arn,
    encryptionKey: Optional[Arn] = Optional.Absent,
    name: RepositoryName,
    provider: zio.aws.proton.model.RepositoryProvider,
    tags: Optional[Iterable[zio.aws.proton.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateRepositoryRequest = {
    import CreateRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateRepositoryRequest
      .builder()
      .connectionArn(Arn.unwrap(connectionArn): java.lang.String)
      .optionallyWith(
        encryptionKey.map(value => Arn.unwrap(value): java.lang.String)
      )(_.encryptionKey)
      .name(RepositoryName.unwrap(name): java.lang.String)
      .provider(provider.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CreateRepositoryRequest.ReadOnly =
    zio.aws.proton.model.CreateRepositoryRequest.wrap(buildAwsValue())
}
object CreateRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateRepositoryRequest =
      zio.aws.proton.model.CreateRepositoryRequest(
        connectionArn,
        encryptionKey.map(value => value),
        name,
        provider,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connectionArn: Arn
    def encryptionKey: Optional[Arn]
    def name: RepositoryName
    def provider: zio.aws.proton.model.RepositoryProvider
    def tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]]
    def getConnectionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(connectionArn)
    def getEncryptionKey: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getName: ZIO[Any, Nothing, RepositoryName] = ZIO.succeed(name)
    def getProvider
        : ZIO[Any, Nothing, zio.aws.proton.model.RepositoryProvider] =
      ZIO.succeed(provider)
    def getTags: ZIO[Any, AwsError, List[zio.aws.proton.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateRepositoryRequest
  ) extends zio.aws.proton.model.CreateRepositoryRequest.ReadOnly {
    override val connectionArn: Arn =
      zio.aws.proton.model.primitives.Arn(impl.connectionArn())
    override val encryptionKey: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKey())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val name: RepositoryName =
      zio.aws.proton.model.primitives.RepositoryName(impl.name())
    override val provider: zio.aws.proton.model.RepositoryProvider =
      zio.aws.proton.model.RepositoryProvider.wrap(impl.provider())
    override val tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.proton.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateRepositoryRequest
  ): zio.aws.proton.model.CreateRepositoryRequest.ReadOnly = new Wrapper(impl)
}
