package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  TemplateVersionPart,
  Arn,
  SpecContents,
  Description,
  RepositoryId,
  ResourceName,
  GitBranchName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateServiceRequest(
    branchName: Optional[GitBranchName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    name: ResourceName,
    repositoryConnectionArn: Optional[Arn] = Optional.Absent,
    repositoryId: Optional[RepositoryId] = Optional.Absent,
    spec: SpecContents,
    tags: Optional[Iterable[zio.aws.proton.model.Tag]] = Optional.Absent,
    templateMajorVersion: TemplateVersionPart,
    templateMinorVersion: Optional[TemplateVersionPart] = Optional.Absent,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateServiceRequest = {
    import CreateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateServiceRequest
      .builder()
      .optionallyWith(
        branchName.map(value => GitBranchName.unwrap(value): java.lang.String)
      )(_.branchName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        repositoryConnectionArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.repositoryConnectionArn)
      .optionallyWith(
        repositoryId.map(value => RepositoryId.unwrap(value): java.lang.String)
      )(_.repositoryId)
      .spec(SpecContents.unwrap(spec): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .templateMajorVersion(
        TemplateVersionPart.unwrap(templateMajorVersion): java.lang.String
      )
      .optionallyWith(
        templateMinorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.templateMinorVersion)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.CreateServiceRequest.ReadOnly =
    zio.aws.proton.model.CreateServiceRequest.wrap(buildAwsValue())
}
object CreateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateServiceRequest =
      zio.aws.proton.model.CreateServiceRequest(
        branchName.map(value => value),
        description.map(value => value),
        name,
        repositoryConnectionArn.map(value => value),
        repositoryId.map(value => value),
        spec,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        templateMajorVersion,
        templateMinorVersion.map(value => value),
        templateName
      )
    def branchName: Optional[GitBranchName]
    def description: Optional[Description]
    def name: ResourceName
    def repositoryConnectionArn: Optional[Arn]
    def repositoryId: Optional[RepositoryId]
    def spec: SpecContents
    def tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]]
    def templateMajorVersion: TemplateVersionPart
    def templateMinorVersion: Optional[TemplateVersionPart]
    def templateName: ResourceName
    def getBranchName: ZIO[Any, AwsError, GitBranchName] =
      AwsError.unwrapOptionField("branchName", branchName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getRepositoryConnectionArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("repositoryConnectionArn", repositoryConnectionArn)
    def getRepositoryId: ZIO[Any, AwsError, RepositoryId] =
      AwsError.unwrapOptionField("repositoryId", repositoryId)
    def getSpec: ZIO[Any, Nothing, SpecContents] = ZIO.succeed(spec)
    def getTags: ZIO[Any, AwsError, List[zio.aws.proton.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField("templateMinorVersion", templateMinorVersion)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceRequest
  ) extends zio.aws.proton.model.CreateServiceRequest.ReadOnly {
    override val branchName: Optional[GitBranchName] = zio.aws.core.internal
      .optionalFromNullable(impl.branchName())
      .map(value => zio.aws.proton.model.primitives.GitBranchName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val repositoryConnectionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryConnectionArn())
      .map(value => zio.aws.proton.model.primitives.Arn(value))
    override val repositoryId: Optional[RepositoryId] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryId())
      .map(value => zio.aws.proton.model.primitives.RepositoryId(value))
    override val spec: SpecContents =
      zio.aws.proton.model.primitives.SpecContents(impl.spec())
    override val tags: Optional[List[zio.aws.proton.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.proton.model.Tag.wrap(item)
          }.toList
        )
    override val templateMajorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMajorVersion())
    override val templateMinorVersion: Optional[TemplateVersionPart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateMinorVersion())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateVersionPart(value)
        )
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceRequest
  ): zio.aws.proton.model.CreateServiceRequest.ReadOnly = new Wrapper(impl)
}
