package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateServiceTemplateVersionResponse(
    serviceTemplateVersion: zio.aws.proton.model.ServiceTemplateVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionResponse = {
    import CreateServiceTemplateVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionResponse
      .builder()
      .serviceTemplateVersion(serviceTemplateVersion.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CreateServiceTemplateVersionResponse.ReadOnly =
    zio.aws.proton.model.CreateServiceTemplateVersionResponse
      .wrap(buildAwsValue())
}
object CreateServiceTemplateVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateServiceTemplateVersionResponse =
      zio.aws.proton.model
        .CreateServiceTemplateVersionResponse(serviceTemplateVersion.asEditable)
    def serviceTemplateVersion
        : zio.aws.proton.model.ServiceTemplateVersion.ReadOnly
    def getServiceTemplateVersion: ZIO[
      Any,
      Nothing,
      zio.aws.proton.model.ServiceTemplateVersion.ReadOnly
    ] = ZIO.succeed(serviceTemplateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionResponse
  ) extends zio.aws.proton.model.CreateServiceTemplateVersionResponse.ReadOnly {
    override val serviceTemplateVersion
        : zio.aws.proton.model.ServiceTemplateVersion.ReadOnly =
      zio.aws.proton.model.ServiceTemplateVersion
        .wrap(impl.serviceTemplateVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateServiceTemplateVersionResponse
  ): zio.aws.proton.model.CreateServiceTemplateVersionResponse.ReadOnly =
    new Wrapper(impl)
}
