package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  ResourceName,
  Subdirectory,
  RepositoryName,
  GitBranchName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateTemplateSyncConfigRequest(
    branch: GitBranchName,
    repositoryName: RepositoryName,
    repositoryProvider: zio.aws.proton.model.RepositoryProvider,
    subdirectory: Optional[Subdirectory] = Optional.Absent,
    templateName: ResourceName,
    templateType: zio.aws.proton.model.TemplateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigRequest = {
    import CreateTemplateSyncConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigRequest
      .builder()
      .branch(GitBranchName.unwrap(branch): java.lang.String)
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .repositoryProvider(repositoryProvider.unwrap)
      .optionallyWith(
        subdirectory.map(value => Subdirectory.unwrap(value): java.lang.String)
      )(_.subdirectory)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .templateType(templateType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CreateTemplateSyncConfigRequest.ReadOnly =
    zio.aws.proton.model.CreateTemplateSyncConfigRequest.wrap(buildAwsValue())
}
object CreateTemplateSyncConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateTemplateSyncConfigRequest =
      zio.aws.proton.model.CreateTemplateSyncConfigRequest(
        branch,
        repositoryName,
        repositoryProvider,
        subdirectory.map(value => value),
        templateName,
        templateType
      )
    def branch: GitBranchName
    def repositoryName: RepositoryName
    def repositoryProvider: zio.aws.proton.model.RepositoryProvider
    def subdirectory: Optional[Subdirectory]
    def templateName: ResourceName
    def templateType: zio.aws.proton.model.TemplateType
    def getBranch: ZIO[Any, Nothing, GitBranchName] = ZIO.succeed(branch)
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getRepositoryProvider
        : ZIO[Any, Nothing, zio.aws.proton.model.RepositoryProvider] =
      ZIO.succeed(repositoryProvider)
    def getSubdirectory: ZIO[Any, AwsError, Subdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
    def getTemplateType: ZIO[Any, Nothing, zio.aws.proton.model.TemplateType] =
      ZIO.succeed(templateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigRequest
  ) extends zio.aws.proton.model.CreateTemplateSyncConfigRequest.ReadOnly {
    override val branch: GitBranchName =
      zio.aws.proton.model.primitives.GitBranchName(impl.branch())
    override val repositoryName: RepositoryName =
      zio.aws.proton.model.primitives.RepositoryName(impl.repositoryName())
    override val repositoryProvider: zio.aws.proton.model.RepositoryProvider =
      zio.aws.proton.model.RepositoryProvider.wrap(impl.repositoryProvider())
    override val subdirectory: Optional[Subdirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.subdirectory())
      .map(value => zio.aws.proton.model.primitives.Subdirectory(value))
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
    override val templateType: zio.aws.proton.model.TemplateType =
      zio.aws.proton.model.TemplateType.wrap(impl.templateType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigRequest
  ): zio.aws.proton.model.CreateTemplateSyncConfigRequest.ReadOnly =
    new Wrapper(impl)
}
