package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateTemplateSyncConfigResponse(
    templateSyncConfig: Optional[zio.aws.proton.model.TemplateSyncConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigResponse = {
    import CreateTemplateSyncConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigResponse
      .builder()
      .optionallyWith(templateSyncConfig.map(value => value.buildAwsValue()))(
        _.templateSyncConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.CreateTemplateSyncConfigResponse.ReadOnly =
    zio.aws.proton.model.CreateTemplateSyncConfigResponse.wrap(buildAwsValue())
}
object CreateTemplateSyncConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.CreateTemplateSyncConfigResponse =
      zio.aws.proton.model.CreateTemplateSyncConfigResponse(
        templateSyncConfig.map(value => value.asEditable)
      )
    def templateSyncConfig
        : Optional[zio.aws.proton.model.TemplateSyncConfig.ReadOnly]
    def getTemplateSyncConfig
        : ZIO[Any, AwsError, zio.aws.proton.model.TemplateSyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("templateSyncConfig", templateSyncConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigResponse
  ) extends zio.aws.proton.model.CreateTemplateSyncConfigResponse.ReadOnly {
    override val templateSyncConfig
        : Optional[zio.aws.proton.model.TemplateSyncConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateSyncConfig())
        .map(value => zio.aws.proton.model.TemplateSyncConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.CreateTemplateSyncConfigResponse
  ): zio.aws.proton.model.CreateTemplateSyncConfigResponse.ReadOnly =
    new Wrapper(impl)
}
