package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteEnvironmentRequest(name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteEnvironmentRequest = {
    import DeleteEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.DeleteEnvironmentRequest.ReadOnly =
    zio.aws.proton.model.DeleteEnvironmentRequest.wrap(buildAwsValue())
}
object DeleteEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteEnvironmentRequest =
      zio.aws.proton.model.DeleteEnvironmentRequest(name)
    def name: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentRequest
  ) extends zio.aws.proton.model.DeleteEnvironmentRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentRequest
  ): zio.aws.proton.model.DeleteEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
